################################################################################
# Function just.varingroup(): "just.varingroup" excludes from a given data     #
# matrix x the genes that are not in any gene functional group.                #
# Input:  1. a gene list 'genes'; each entry itsself is a list of pathway      #
#         names ( if a gene is not in any pathway, the entry is 'NA')          #
#         2. the data matrix x                                                 #
# Output: a vector of gene names that are in at least one pathway              #
################################################################################


just.varingroup  <- function(genes,x){
                    colnames(x)[sapply(genes[colnames(x)],function(ll) !any(is.na(ll)))]
                    }
